package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer user role type related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "userRoleType")
@JsonInclude(Include.NON_NULL)
public class UserRoleTypeDTO implements Serializable {

	private static final long serialVersionUID = 459080072946157484L;

	private int id;
	private int roleTypeId;
	private RoleTypeDTO roleType;
	private int userTypeId;
	private UserTypeDTO userType;
	private int userId;
	private Date startDate;
	private Date endDate;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the roleTypeId
	 */
	public int getRoleTypeId() {
		return roleTypeId;
	}

	/**
	 * @param roleTypeId
	 *            the roleTypeId to set
	 */
	public void setRoleTypeId(int roleTypeId) {
		this.roleTypeId = roleTypeId;
	}

	/**
	 * @return the roleType
	 */
	public RoleTypeDTO getRoleType() {
		return roleType;
	}

	/**
	 * @param roleType
	 *            the roleType to set
	 */
	public void setRoleType(RoleTypeDTO roleType) {
		this.roleType = roleType;
	}

	/**
	 * @return the userTypeId
	 */
	public int getUserTypeId() {
		return userTypeId;
	}

	/**
	 * @param userTypeId
	 *            the userTypeId to set
	 */
	public void setUserTypeId(int userTypeId) {
		this.userTypeId = userTypeId;
	}

	/**
	 * @return the userType
	 */
	public UserTypeDTO getUserType() {
		return userType;
	}

	/**
	 * @param userType
	 *            the userType to set
	 */
	public void setUserType(UserTypeDTO userType) {
		this.userType = userType;
	}

	/**
	 * @return the userId
	 */
	public int getUserId() {
		return userId;
	}

	/**
	 * @param userId
	 *            the userId to set
	 */
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * @return the startDate
	 */
	public Date getStartDate() {
		return startDate;
	}

	/**
	 * @param startDate
	 *            the startDate to set
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	/**
	 * @return the endDate
	 */
	public Date getEndDate() {
		return endDate;
	}

	/**
	 * @param endDate
	 *            the endDate to set
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
}